/* Copyright (C) 2001 Agilent Technologies Company */
/* VXIplug&play Instrument Driver for the age8481a*/

#ifndef age8481a_INCLUDE 
#define age8481a_INCLUDE
#include "vpptype.h"

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*=============================*/
/*           age8481a           */
/*=============================*/
/* Framework Revision: WIN95 4.0 */
/*                     WINNT 4.0 */
/* Driver Revision:    A.01.00 */
/* Firmware Revision:  G.11.00 */
/*=============================*/

/*=============================*/
/* Source Files:               */
/*=============================*/
/*   age8481a.c                 */
/*   age8481a.h                 */
/*=============================*/

/*=============================*/
/* WIN Framework Files         */
/*=============================*/
/*   age8481a.def               */
/*   age8481a.rc                */
/*   age8481a.bas               */
/*=============================*/

/******  Returned error status values *****/
/* HP Common Error numbers start at BFFC0D00 */
#define age8481a_INSTR_ERROR_NOT_VXI       (_VI_ERROR+0x3FFC0D00L) /* 0xBFFC0D00 */
/* D01 unused*/
#define age8481a_INSTR_ERROR_NULL_PTR      (_VI_ERROR+0x3FFC0D02L) /* 0xBFFC0D02 */
#define age8481a_INSTR_ERROR_RESET_FAILED  (_VI_ERROR+0x3FFC0D03L) /* 0xBFFC0D03 */
#define age8481a_INSTR_ERROR_UNEXPECTED    (_VI_ERROR+0x3FFC0D04L) /* 0xBFFC0D04 */
#define age8481a_INSTR_ERROR_INV_SESSION   (_VI_ERROR+0x3FFC0D05L) /* 0xBFFC0D05 */
#define age8481a_INSTR_ERROR_LOOKUP        (_VI_ERROR+0x3FFC0D06L) /* 0xBFFC0D06 */
#define age8481a_INSTR_ERROR_DETECTED      (_VI_ERROR+0x3FFC0D07L) /* 0xBFFC0D07 */

#define age8481a_USER_ERROR_HANDLER			-1

/******   Used by Status System Functions   *****/
#define age8481a_STB_MAV				5 

#define age8481a_ESR_OPC				601
#define age8481a_ESR_QUERY_ERROR			603
#define age8481a_ESR_DEVICE_DEPENDENT_ERROR		604
#define age8481a_ESR_EXECUTION_ERROR			605
#define age8481a_ESR_COMMAND_ERROR			606

#define age8481a_OPER_SCAN_DONE			809

/******   Used by Function age8481a_timeOut   *****/
#define  age8481a_TIMEOUT_MAX  2147483647
#define  age8481a_TIMEOUT_MIN  0
#define	age8481a_INTERRUPT_LINE_MAX	7
#define	age8481a_INTERRUPT_LINE_MIN	0

#define INST ViSession

/* required plug and play functions from VPP-3.1*/
ViStatus _VI_FUNC age8481a_init (ViRsrc InstrDesc, ViBoolean id_query,
								 ViBoolean do_reset, ViPSession vi );

ViStatus _VI_FUNC age8481a_close (ViSession vi);

ViStatus _VI_FUNC age8481a_reset (ViSession vi);

ViStatus _VI_FUNC age8481a_self_test (ViSession vi, ViPInt16 test_result,
									  ViChar _VI_FAR test_message[]);

ViStatus _VI_FUNC age8481a_error_query (ViSession vi, ViPInt32 error_number,
										ViChar _VI_FAR error_message[]);

ViStatus _VI_FUNC age8481a_error_message (ViSession vi, ViStatus error_number,
										  ViChar _VI_FAR message[]);

ViStatus _VI_FUNC age8481a_revision_query (ViSession vi, ViChar _VI_FAR driver_rev[],
										   ViChar _VI_FAR instr_rev[]);

/* HP other standard functions */

ViStatus _VI_FUNC age8481a_dcl(ViSession vi);

ViStatus _VI_FUNC age8481a_errorQueryDetect(ViSession vi, ViBoolean errDetect);

ViStatus _VI_FUNC age8481a_errorQueryDetect_Q(ViSession vi, ViPBoolean pErrDetect);

ViStatus _VI_FUNC age8481a_opc(ViSession vi);

ViStatus _VI_FUNC age8481a_opc_Q(ViSession vi, ViPInt16 opc);

ViStatus _VI_FUNC age8481a_readStatusByte_Q(ViSession vi, ViPInt16 statusByte);

ViStatus _VI_FUNC age8481a_statEvenClr(ViSession vi);

ViStatus _VI_FUNC age8481a_statEven_Q(ViSession vi, ViInt32 happening,
									  ViPBoolean pEvent);

#ifdef INSTR_CALLBACKS

typedef void (_VI_FUNCH _VI_PTR  age8481a_InstrEventHandler)(
        ViSession vi, ViInt32 happening, ViAddr userData);     
	
ViStatus _VI_FUNC age8481a_statEvenHdlr(ViSession vi, ViInt32 happening,
										age8481a_InstrEventHandler eventHandler,
										ViAddr userData);

typedef void (_VI_FUNCH _VI_PTR _VI_PTR age8481a_InstrPEventHandler)(
	ViSession vi, ViInt32 happening, ViAddr userData);

ViStatus _VI_FUNC age8481a_statEvenHdlr_Q(ViSession vi, ViInt32 happening,
                                     age8481a_InstrPEventHandler pEventHandler,
                                     ViPAddr pUserData);

ViStatus _VI_FUNC age8481a_statEvenHdlrDelAll(ViSession vi);
#endif /* INSTR_CALLBACKS */

ViStatus _VI_FUNC age8481a_timeOut (ViSession vi, ViInt32 timeOut);

ViStatus _VI_FUNC age8481a_timeOut_Q (ViSession vi, ViPInt32 timeOut);

ViStatus _VI_FUNC age8481a_trg(ViSession vi);

ViStatus _VI_FUNC age8481a_wai(ViSession vi);

/* Instr Specific Functions follow */

/******   Used by Function age8481a_armCoun   *****/
#define  age8481a_ARM_COUN_MAX  32767
#define  age8481a_ARM_COUN_MIN  1

/******   Used by Function age8481a_closRowCol16x16   *****/
#define  age8481a_CARD_MAX  99
#define  age8481a_CARD_MIN  1
#define  age8481a_ROW_MIN  0
#define  age8481a_COL_MIN  0
#define  age8481a_PATTERN_MAX 510
#define  age8481a_PATTERN_MIN 0

/******   Used by Function age8481a_closRowCol4x32   *****/
/*  age8481a_CARD_MAX  */
/*  age8481a_CARD_MIN  */
#define  age8481a_ROW_MAX  3
/*  age8481a_ROW_MIN  */
#define  age8481a_COL_MAX  31
/*  age8481a_COL_MIN  */

/******   Used by Function age8481a_outpEcltStat_M   *****/
#define  age8481a_ECLTNUM_MAX  1
#define  age8481a_ECLTNUM_MIN  0

/******   Used by Function age8481a_outpEcltStat_M_Q   *****/
/*  age8481a_ECLTNUM_MAX  */
/*  age8481a_ECLTNUM_MIN  */

/******   Used by Function age8481a_outpTtltStat_M   *****/
#define  age8481a_TTLTNUM_MAX  7
#define  age8481a_TTLTNUM_MIN  0

/******   Used by Function age8481a_outpTtltStat_M_Q   *****/
/*  age8481a_TTLTNUM_MAX  */
/*  age8481a_TTLTNUM_MIN  */

/******   Used by Function age8481a_routClos   *****/
#define  age8481a_CHANNEL_MAX  999999
#define  age8481a_CHANNEL_MIN  100

/******   Used by Function age8481a_routClos_Q   *****/
/*  age8481a_CHANNEL_MAX  */
/*  age8481a_CHANNEL_MIN  */

/******   Used by Function age8481a_routOpen   *****/
/*  age8481a_CHANNEL_MAX  */
/*  age8481a_CHANNEL_MIN  */

/******   Used by Function age8481a_routOpen_Q   *****/
/*  age8481a_CHANNEL_MAX  */
/*  age8481a_CHANNEL_MIN  */

/******   Used by Function age8481a_systCdes_Q   *****/
/*  age8481a_CARD_MAX  */
/*  age8481a_CARD_MIN  */

/******   Used by Function age8481a_systCpon   *****/
/*  age8481a_CARD_MAX  */
/*  age8481a_CARD_MIN  */

/******   Used by Function age8481a_systCtyp_Q   *****/
/*  age8481a_CARD_MAX  */
/*  age8481a_CARD_MIN  */

/******   Used by Function age8481a_trigSour   *****/
#define  age8481a_TRIG_SOUR_BUS  0
#define  age8481a_TRIG_SOUR_ECLT0  1
#define  age8481a_TRIG_SOUR_ECLT1  2
#define  age8481a_TRIG_SOUR_HOLD  3
#define  age8481a_TRIG_SOUR_IMM  4
#define  age8481a_TRIG_SOUR_TTLT0  5
#define  age8481a_TRIG_SOUR_TTLT1  6
#define  age8481a_TRIG_SOUR_TTLT2  7
#define  age8481a_TRIG_SOUR_TTLT3  8
#define  age8481a_TRIG_SOUR_TTLT4  9
#define  age8481a_TRIG_SOUR_TTLT5  10
#define  age8481a_TRIG_SOUR_TTLT6  11
#define  age8481a_TRIG_SOUR_TTLT7  12
#define  age8481a_TRIG_SOUR_EXT  13

/******   Used by Function age8481a_trigSour_Q   *****/
/*  age8481a_TRIG_SOUR_BUS  */
/*  age8481a_TRIG_SOUR_ECLT0  */
/*  age8481a_TRIG_SOUR_ECLT1  */
/*  age8481a_TRIG_SOUR_HOLD  */
/*  age8481a_TRIG_SOUR_IMM  */
/*  age8481a_TRIG_SOUR_TTLT0  */
/*  age8481a_TRIG_SOUR_TTLT1  */
/*  age8481a_TRIG_SOUR_TTLT2  */
/*  age8481a_TRIG_SOUR_TTLT3  */
/*  age8481a_TRIG_SOUR_TTLT4  */
/*  age8481a_TRIG_SOUR_TTLT5  */
/*  age8481a_TRIG_SOUR_TTLT6  */
/*  age8481a_TRIG_SOUR_TTLT7  */
/*  age8481a_TRIG_SOUR_EXT  */

ViStatus _VI_FUNC age8481a_abor (ViSession vi);

ViStatus _VI_FUNC age8481a_armCoun (ViSession vi,
									ViInt16 armCoun);

ViStatus _VI_FUNC age8481a_armCoun_Q (ViSession vi,
									  ViPInt16 armCoun);

ViStatus _VI_FUNC age8481a_closRowCol4x32 (ViSession vi,
										   ViInt16 Card_Number,
										   ViInt16 Row,
										   ViInt16 Column);

ViStatus _VI_FUNC age8481a_initCont (ViSession vi,
									 ViBoolean initCont);

ViStatus _VI_FUNC age8481a_initCont_Q (ViSession vi,
									   ViPBoolean initCont);

ViStatus _VI_FUNC age8481a_initImm (ViSession vi);

ViStatus _VI_FUNC age8481a_interLine(ViSession vi,
									 ViInt16 card,
									 ViInt16 line);

ViStatus _VI_FUNC age8481a_interLine_Q(ViSession vi,
									   ViInt16 card,
									   ViPInt16 line);

ViStatus _VI_FUNC age8481a_interTimer(ViSession vi,
									  ViInt16 card,
									  ViReal64 timer);

ViStatus _VI_FUNC age8481a_interTimer_Q	(ViSession vi,
										 ViInt16 card,
										 ViPReal64 timer);

ViStatus _VI_FUNC age8481a_operEvent_Q(ViSession vi,
									   ViPInt32 OperEventRegister);

ViStatus _VI_FUNC age8481a_operCond_Q(ViSession vi,
									  ViPInt32 OperCondRegister);

ViStatus _VI_FUNC age8481a_outpEcltStat_M (ViSession vi,
										   ViInt16 ecltNum,
										   ViBoolean outpEcltStat);

ViStatus _VI_FUNC age8481a_outpEcltStat_M_Q (ViSession vi,
											 ViInt16 ecltNum,
											 ViPBoolean outpEcltStat);

ViStatus _VI_FUNC age8481a_outpStat (ViSession vi,
									 ViBoolean outpStat);

ViStatus _VI_FUNC age8481a_outpStat_Q (ViSession vi,
									   ViPBoolean outpStat);

ViStatus _VI_FUNC age8481a_outpTtltStat_M (ViSession vi,
										   ViInt16 ttltNum,
										   ViBoolean outpTtltStat);

ViStatus _VI_FUNC age8481a_outpTtltStat_M_Q (ViSession vi,
											 ViInt16 ttltNum,
											 ViPBoolean outpTtltStat);

ViStatus _VI_FUNC age8481a_routClos (ViSession vi,
									 ViInt32 channel);

ViStatus _VI_FUNC age8481a_routClosList (ViSession vi,
										 ViString channelList);

ViStatus _VI_FUNC age8481a_routClosList_Q (ViSession vi,
										   ViString channelList,
										   ViChar _VI_FAR routClosList[]);

ViStatus _VI_FUNC age8481a_routClos_Q (ViSession vi,
									   ViInt32 channel,
									   ViPBoolean routClos);

ViStatus _VI_FUNC age8481a_routFunc (ViSession vi,
									 ViInt16 card,
									 ViString cMode);

ViStatus _VI_FUNC age8481a_routFunc_Q (ViSession vi,
									   ViInt16 card,
									   ViChar _VI_FAR cMode[]);

ViStatus _VI_FUNC age8481a_routOpen (ViSession vi,
									 ViInt32 channel);

ViStatus _VI_FUNC age8481a_routOpenList (ViSession vi,
										 ViString channelList);

ViStatus _VI_FUNC age8481a_routOpenList_Q (ViSession vi,
										   ViString channelList,
										   ViChar _VI_FAR routOpenList[]);

ViStatus _VI_FUNC age8481a_routOpen_Q (ViSession vi,
									   ViInt32 channel,
									   ViPBoolean routOpen);

ViStatus _VI_FUNC age8481a_routPattern(ViSession vi,
									   ViInt16 card,
									   ViInt16 pattern);

ViStatus _VI_FUNC age8481a_routPattern_Q(ViSession vi,
										 ViInt16 card,
										 ViPInt16 pattern);

ViStatus _VI_FUNC age8481a_routPattActivate(ViSession vi,
											ViInt16 card,
											ViInt16 pattern);

ViStatus _VI_FUNC age8481a_routPattActivate_Q(ViSession vi,
											  ViInt16 card,
											  ViPInt16 pattern);

ViStatus _VI_FUNC age8481a_routPattClosList(ViSession vi,
											ViString channelList);

ViStatus _VI_FUNC age8481a_routPattClosList_Q(ViSession vi,
											  ViString channelList,
											  ViChar _VI_FAR routClosList[]);

ViStatus _VI_FUNC age8481a_routPattOpenList(ViSession vi,
											ViString channelList);

ViStatus _VI_FUNC age8481a_routPattOpenList_Q(ViSession vi,
											  ViString channelList,
											  ViChar _VI_FAR routOpenList[]);

ViStatus _VI_FUNC age8481a_routScanList (ViSession vi,
										 ViString channelList);

ViStatus _VI_FUNC age8481a_systCdes_Q (ViSession vi,
									   ViInt16 card,
									   ViChar _VI_FAR systCdes[]);

ViStatus _VI_FUNC age8481a_systCpon (ViSession vi,
									 ViInt16 card);

ViStatus _VI_FUNC age8481a_systCtyp_Q (ViSession vi,
									   ViInt16 card,
									   ViChar _VI_FAR systCtyp[]);

ViStatus _VI_FUNC age8481a_trigImm (ViSession vi);

ViStatus _VI_FUNC age8481a_trigSour (ViSession vi,
									 ViInt16 trigSour);

ViStatus _VI_FUNC age8481a_trigSour_Q (ViSession vi,
									   ViPInt16 trigSour);
/* Used for "C" externs in C++ */
#if defined(__cplusplus) || defined(__cplusplus__)
}    /* end of "C" externs for C++ */
#endif 

#endif /* age8481a_INCLUDE */

